 (defmeth missing-data-model-object-proto :visualize-multiple-imputation ()
  (let 
    (
    (bx-corr-mi (send self :bx-corr-mi)))

    ))
                

 
(defmeth missing-data-model-object-proto :bx-corr-mi ()
 (let* (
       (n (length (send current-model :multiple-imputed-data-sets-list)))
       (listscorrs 
        (mapcar #'(lambda (dataset)
                    (matrix-to-list
                     (correlation-matrix 
                      (send dataset :data-matrix ))))       
                (send current-model :multiple-imputed-data-sets-list)))
       (bxplot (boxplot listscorrs) 
               :draw t))
   (send bxplot :connect-points t)
   (send bxplot :enable-connect-points t)
   (send bxplot :title "Correlations")
   (send bxplot ::y-axis-label "correlations") 
   
  (send bxplot :point-label (iseq  (* n (length (first listscorrs))))
          (mapcar 'princ-to-string (/ (round (* 100 (combine listscorrs))) 100))) 

    (defmeth bxplot :plot-help ()
      (plot-help-window (strcat "Help for " (send self :title)))
      (paste-plot-help (format nil "TO BE CHANGED

These boxplots (see explanation of boxplots) show the values in the lowest triangle of the matrix of correlations for data  computed in different ways. From left to right you can see the distribution of the Maximum Likelihood (ML) correlations computed using the Estimation-Maximization algorithm, the correlations using pairwise deletion and the correlations using listwise deletion. These methods are designed to deal with missing values. Data with no missing values will produce the same correlations using any of the different methods. 
These boxplots are connected son you can examine each correlation one by one pointing with the mouse in each point. Points changing between boxplots are more interesting and should be checked carefully. Also, the boxplots can be compared to determine whether any of the methods produces bigger correlations than the others. 
The information in this plot is the same as in the scatterplot matrix of correlations and both plots can be used complementarily."))
      (show-plot-help))
  ))
         
